/* APP */

// Application
;(function(b,a){b.Application=a.extend({model:{},view:{},service:{},template:{}},Backbone.Events)})(window,_);
// Sound player
;(function(d,c,b){var a=d.SoundPlayer=function(){this.play=function(g){};var e=[];this.addSounds=function(g){e.push(g)};var f=this;c.setup({url:b.rootPath+"swf/",onready:function(){f.play=function(h){c.play(h)};f.addSounds=function(h){for(var i in h){c.createSound({id:i,url:b.rootPath+h[i],autoLoad:true,autoPlay:false,volume:100})}};f.addSounds({message:b.ui.messageSound});if(e.length>0){for(var g=0;g<e.length;g++){f.addSounds(e[g])}}}})}})(window.Application,soundManager,chatConfig);
// Guest settings model
;(function(b,a){b.GuestSettingsModel=Backbone.Model.extend({defaults:{sound:true,scroll:true,emots:true,show:true},initialize:function(){this.fetch();this.on("change",this.save,this)},save:function(){a.cookie("customer-chat-settings",JSON.stringify(this.attributes))},fetch:function(){if(a.cookie("customer-chat-settings")){this.set(JSON.parse(a.cookie("customer-chat-settings")))}}})})(window.Application,jQuery);
// Message model
;(function(a){a.MessageModel=Backbone.Model.extend({defaults:{author:"",body:"",toAuthor:"all",toAuthorMail:""},initialize:function(c,f){if(c){if(c.datetime){this.set("time",new Date(c.datetime.replace(/-/g,"/")))}if(typeof c.from_user_info==="string"&&c.from_user_info!=="all"){try{c.from_user_info=JSON.parse(c.from_user_info)}catch(g){}}if(typeof c.from_user_info==="object"){var d=c.from_user_info;this.fromUser=d;if(this.get("author").length===0){this.set("author",d.name)}if(!this.has("authorMail")){this.set("authorMail",d.mail)}}if(typeof c.to_user_info==="string"&&c.to_user_info!=="all"){try{c.to_user_info=JSON.parse(c.to_user_info)}catch(g){}}if(typeof c.to_user_info==="object"){var b=c.to_user_info;this.toUser=b;this.set("toAuthor",b.name);this.set("toAuthorMail",b.mail)}}},getAge:function(){var b=Math.floor(new Date().getTime()/1000);var c=Math.floor(this.get("time").getTime()/1000);return Math.ceil(b-c)},getReadableName:function(){var b=this.get("author");return b.lastIndexOf("-")!==-1?b.slice(0,b.lastIndexOf("-")):b},getToUserReadableName:function(){var b=this.get("toAuthor");return b.lastIndexOf("-")!==-1?b.slice(0,b.lastIndexOf("-")):b},getTalkName:function(){var b=this.get("toAuthor");return this.getReadableName()+(b?"/"+(b.lastIndexOf("-")!==-1?b.slice(0,b.lastIndexOf("-")):b):"")}})})(window.Application);
// Guest chat model
;(function(e,d,b,a){var c=e.GuestChatModel=Backbone.Model.extend({defaults:{name:"anonymous",mail:""},operatorsCache:{},lastMessages:[],lastTypingUpdate:0,initialize:function(){this.once("operators:online",this.manageConnection,this);this.on("messages:new",this.storeMessages,this)},autoLogin:function(){var f=this;d.post(b.isLoggedInPath,{info:JSON.stringify(b.info)},function(g){if(g.success){f.set({name:g.name,mail:g.mail,image:g.image});f.trigger("login:success");d.get(b.lastMessagesPath,function(h){if(h.success&&h.messages.length>0){f.trigger("messages:last",h.messages)}})}else{f.trigger("login:login")}})},login:function(f){var g=this;f.info=JSON.stringify(b.info);d.post(b.loginPath,f,function(h){if(h.success){g.set({name:f.name,mail:f.mail,image:f.image});g.trigger("login:success")}else{g.trigger("login:error")}})},checkOperators:function(){var f=this;d.get(b.isOperatorOnlinePath,function(g){if(g.success){f.trigger("operators:online")}else{f.trigger("operators:offline")}})},keepAlive:function(){d.get(b.keepAlivePath)},updateTypingStatus:function(){var f=this.lastOperator&&this.lastOperator.id;if(f){var g=(new Date()).getTime();if(this.lastTypingUpdate+c.POLLING_INTERVAL<g){this.lastTypingUpdate=g;d.post(b.updateTypingStatusPath,{secondUserId:f,status:true})}}},getTypingStatus:function(){var f=this.lastOperator&&this.lastOperator.id;if(f){var g=this;d.post(b.getTypingStatusPath,{ids:[f]},function(h){if(h.success&&h.results[f]){g.trigger("operator:typing")}})}},getMessages:function(){var f=this;d.get(b.newMessagesPath,function(g){if(g.length>0){f.loadOperatorsData(g,function(){g.authorType="operator";f.trigger("messages:new",g)})}})},storeMessages:function(f){a.each(f,function(g){if(!g.datetime&&g.time){g.datetime=g.time.getTime()}});this.lastMessages=this.lastMessages.concat(f)},storeOperator:function(f){this.lastOperator=this.operatorsCache[f.id]=f},loadOperatorsData:function(j,l){var k=this;var h=0;for(var f=0;f<j.length;f++){var g=j[f];if(!this.operatorsCache[g.from_id]){h++;d.post(b.getOperatorPath,{id:g.from_id}).success(function(i){if(i.success){k.storeOperator(i.user)}}).always(function(){h--;if(h<=0){l()}})}}if(h<=0){l()}},getOperatorName:function(f){return this.operatorsCache[f]&&this.operatorsCache[f].name},sendMessage:function(g){var f={body:g.get("body")};var h=this;d.post(b.sendMessagePath,f,function(i){if(i.success){h.trigger("messages:sent")}else{h.trigger("messages:sendError")}});this.storeMessages([g.attributes])},manageConnection:function(){var f=this;setInterval(function(){f.getMessages();f.keepAlive();f.getTypingStatus();f.checkOperators()},c.POLLING_INTERVAL)}},{POLLING_INTERVAL:5000})})(window.Application,jQuery,window.chatConfig,_);
// Login view
;(function(b,a){b.LoginFormView=Backbone.View.extend({mailExp:new RegExp("^[-+\\.0-9=a-z_]+@([-0-9a-z]+\\.)+([0-9a-z]){2,4}$","i"),nameValid:false,mailValid:false,initialize:function(){this.$name=this.$("#customer-chat-login-name");this.$mail=this.$("#customer-chat-login-mail");this.$name.on("input change keydown blur",a.proxy(this.validateName,this));this.$mail.on("input change keydown blur",a.proxy(this.validateMail,this))},reset:function(){this.$name.val("");this.$mail.val("");this.$name.removeClass("customer-chat-input-error");this.$mail.removeClass("customer-chat-input-error")},validateName:function(){if(this.$name.val().length==0){this.$name.addClass("customer-chat-input-error");this.nameValid=false}else{this.$name.removeClass("customer-chat-input-error");this.nameValid=true}},validateMail:function(){if(this.$mail.val().length==0||!this.mailExp.test(this.$mail.val())){this.$mail.addClass("customer-chat-input-error");this.mailValid=false}else{this.$mail.removeClass("customer-chat-input-error");this.mailValid=true}},isValid:function(){this.validateName();this.validateMail();return this.nameValid&&this.mailValid}})})(window.Application,jQuery);
// Contact form view
;(function(b,a){b.ContactFormView=Backbone.View.extend({mailExp:new RegExp("^[-+\\.0-9=a-z_]+@([-0-9a-z]+\\.)+([0-9a-z]){2,4}$","i"),nameValid:false,mailValid:false,messageValid:false,initialize:function(){this.$name=this.$("#customer-chat-contact-name");this.$mail=this.$("#customer-chat-contact-mail");this.$message=this.$("#customer-chat-contact-message");this.$name.on("input change keydown blur",a.proxy(this.validateName,this));this.$mail.on("input change keydown blur",a.proxy(this.validateMail,this));this.$message.on("input change keydown blur",a.proxy(this.validateMessage,this))},reset:function(){this.$name.val("");this.$mail.val("");this.$message.val("");this.$name.removeClass("customer-chat-input-error");this.$mail.removeClass("customer-chat-input-error");this.$message.removeClass("customer-chat-input-error")},validateName:function(){if(this.$name.val().length==0){this.$name.addClass("customer-chat-input-error");this.nameValid=false}else{this.$name.removeClass("customer-chat-input-error");this.nameValid=true}},validateMail:function(){if(this.$mail.val().length==0||!this.mailExp.test(this.$mail.val())){this.$mail.addClass("customer-chat-input-error");this.mailValid=false}else{this.$mail.removeClass("customer-chat-input-error");this.mailValid=true}},validateMessage:function(){if(this.$message.val().length<6){this.$message.addClass("customer-chat-input-error");this.messageValid=false}else{this.$message.removeClass("customer-chat-input-error");this.messageValid=true}},isValid:function(){this.validateName();this.validateMail();this.validateMessage();return this.nameValid&&this.mailValid&&this.messageValid}})})(window.Application,jQuery);
// Message view
;(function(e,a,d){var c=/(\w+:\/\/)?([\da-z\.\-@]+)\.([a-z\.]{2,6})([?&=%#;\/\w \.-]*)*\/?/g;var b=e.MessageView=Backbone.View.extend({initialize:function(){this.settings=e.model.settings;this.listenTo(this.model,"change",this.render);this.render();this.$el.hide();this.$el.fadeIn("fast")},render:function(){this.$el.html(d(e.template.message));this.$time=this.$(".customer-chat-content-message-time");var f=this.model.get("body").split("<").join("&lt;").split(">").join("&gt;");f=this.prepareMessage(f);this.$(".customer-chat-content-message-author").html(this.model.getReadableName()||this.model.get("author"));this.$(".customer-chat-content-message-body").html(f);this.updateTime(true);if(this.model.get("authorType")=="operator"){this.$(".customer-chat-content-message").removeClass("customer-chat-content-message").addClass("customer-chat-content-message-operator");this.$(".customer-chat-content-message-avatar").removeClass("customer-chat-content-message-avatar").addClass("customer-chat-content-message-avatar-operator")}if(this.model.fromUser&&this.model.fromUser.image){this.$(".avatar").css("background-image",'url("'+this.model.fromUser.image+'")')}if(e.UserInfoPopoverView){new e.UserInfoPopoverView({model:this.model,button:this.$(".customer-chat-content-message-author")[0]})}},prepareMessage:function(f){f=f.replace(c,function(h,i){if(h.indexOf("@")!==-1){return h}if(h.indexOf("..")!==-1){return h}return b.createLinkElement(h,(i?"":"http://")+h)});if(this.settings.get("emots")){for(var g in b.EMOTICONS){f=f.split(g).join(b.createEmotElement(b.EMOTICONS[g]))}}return f},updateTime:function(g){var o=this.model.getAge();var j=Math.floor(o/60);var n=Math.floor(j/60);var q=Math.floor(n/24);var f=Math.floor(q/7);var i=this.model.get("time");var l=(i.getDate()<10?"0":"")+i.getDate()+"."+((i.getMonth()+1)<10?"0":"")+(i.getMonth()+1)+"."+i.getFullYear();var k=(i.getHours()<10?"0":"")+i.getHours()+":"+(i.getMinutes()<10?"0":"")+i.getMinutes()+":"+(i.getSeconds()<10?"0":"")+i.getSeconds();var m=l+" "+k;if(this.options.fullDate){this.$time.html(m);return}var p=f>0?m:q>0?q+" "+a.ui.timeDaysAgo:n>0?n+" "+a.ui.timeHoursAgo:j>0?j+" "+a.ui.timeMinutesAgo:Math.max((o-o%5),1)+" "+a.ui.timeSecondsAgo;this.$time.html(p);if(g){var h=q>0?-1:n>0?(60-j%60)*60*60:j>5?(5-j%5)*60:j>0?60:10-o%10;if(h==-1){return}var r=this;this.timerId=setTimeout(function(){r.updateTime(true)},h*1000)}},clean:function(){if(this.timerId){clearTimeout(this.timerId)}return this}},{EMOTICONS:{"&gt;:|":a.rootPath+"img/emots/emot-9.png","&gt;:D":a.rootPath+"img/emots/emot-10.png",o_O:a.rootPath+"img/emots/emot-11.png",":-D":a.rootPath+"img/emots/emot-18.png",";-D":a.rootPath+"img/emots/emot-19.png","*-D":a.rootPath+"img/emots/emot-20.png",":)":a.rootPath+"img/emots/emot-1.png",";)":a.rootPath+"img/emots/emot-2.png",":(":a.rootPath+"img/emots/emot-3.png",":D":a.rootPath+"img/emots/emot-4.png",":P":a.rootPath+"img/emots/emot-5.png","=)":a.rootPath+"img/emots/emot-6.png",":|":a.rootPath+"img/emots/emot-7.png","=|":a.rootPath+"img/emots/emot-8.png","=O":a.rootPath+"img/emots/emot-12.png","&lt;3":a.rootPath+"img/emots/emot-13.png",":S":a.rootPath+"img/emots/emot-14.png",":*":a.rootPath+"img/emots/emot-15.png",":$":a.rootPath+"img/emots/emot-16.png","=B":a.rootPath+"img/emots/emot-17.png"},createEmotElement:function(f){return'<img src="'+f+'" />'},createLinkElement:function(g,f){if(g.length>40){}return'<a href="'+f+'" target="_blank">'+g+"</a>"}})})(window.Application,window.chatConfig,jQuery);
// Chatbox view
;(function(c,b){var a=c.ChatBoxView=Backbone.View.extend({initialize:function(){this.settings=c.model.settings;this.$wrapper=this.$(".customer-chat-content-messages-wrapper");this.$el.mCustomScrollbar();this.messageViews=[]},addMessage:function(g,e,f){var d=new c.MessageView({model:g,fullDate:this.options.fullDate});this.messageViews.push(d);this.$wrapper.append(d.el);var h=this;setTimeout(function(){h.$el.mCustomScrollbar("update");if(f){if(e){h.$el.mCustomScrollbar("scrollTo","bottom")}}else{if(h.settings.get("scroll")||e){h.$el.mCustomScrollbar("scrollTo","bottom")}}},200)},clear:function(){for(var d=0;d<this.messageViews.length;d++){this.messageViews[d].remove().clean()}this.$wrapper.html("");this.messageViews=[]}})})(window.Application,jQuery);
// Widget view
;(function(d,c,b){var a=d.WidgetView=Backbone.View.extend({events:{"click #customer-chat-login-start":"login","keydown #customer-chat-content-login-form input":"loginOnEnter","click #customer-chat-button-toggle":"toggle","click #customer-chat-button-settings":"toggleSettings","click .customer-chat-content-message-emots-button":"toggleEmoticons","click .customer-chat-toggle-sound":"toggleSetting","click .customer-chat-toggle-scroll":"toggleSetting","click .customer-chat-toggle-emots":"toggleSetting","click .customer-chat-toggle-show":"toggleSetting","click .customer-chat-emoticon":"addEmoticon","keydown #customer-chat-message-input":"sendMessage","click #customer-chat-contact-send":"sendContactMessage","click #customer-chat-info-back":"showPrevState"},initialized:false,visible:false,state:"",prevState:"",titleBlinking:false,typingInfoBlinking:false,emotsVisible:false,initialize:function(){this.settings=d.model.settings;this.loginForm=new d.LoginFormView({el:this.$("#customer-chat-content-login-form")});this.chatBox=new d.ChatBoxView({el:this.$(".customer-chat-content-messages")});this.contactForm=new d.ContactFormView({el:this.$("#customer-chat-content-contact-form")});this.selectAvatar=new d.SelectAvatarInlineView({el:this.$("#customer-chat-select-avatar"),model:b.defaultAvatars});this.$frame=c(window.frameElement);this.$header=this.$(".customer-chat-header");this.$title=this.$(".customer-chat-header-title");this.$toggleBtn=this.$("#customer-chat-button-toggle");this.$settingsBtn=this.$("#customer-chat-button-settings");this.$settings=this.$(".customer-chat-header-menu");this.$typingInfo=this.$(".typing-indicator");this.$emoticons=this.$(".customer-chat-emots-menu");this.$input=this.$("#customer-chat-message-input");this.$contactName=this.$("#customer-chat-contact-name");this.$contactMail=this.$("#customer-chat-contact-mail");this.$contactMessage=this.$("#customer-chat-contact-message");this.$loginName=this.$("#customer-chat-login-name");this.$loginMail=this.$("#customer-chat-login-mail");this.$info=this.$("#customer-chat-info-text");this.$toggleSound=this.$(".customer-chat-toggle-sound");this.$toggleScroll=this.$(".customer-chat-toggle-scroll");this.$toggleEmots=this.$(".customer-chat-toggle-emots");this.$toggleShow=this.$(".customer-chat-toggle-show");this.showLoading();this.model.once("operators:online",this.autoLogin,this);this.model.once("operators:offline",this.showContact,this);this.model.once("operators:online",function(){this.$frame.show();this.initialized=true},this);this.model.once("operators:offline",function(){if(!this.initialized&&b.ui.hideWhenOffline==="true"){this.$frame.hide()}else{this.$frame.show()}},this);c('a[href="#"]').click(function(f){f.preventDefault()});this.model.on("login:success",this.showChat,this);this.model.on("login:login",this.showLogin,this);this.model.on("login:error",this.showLoginError,this);this.model.once("messages:last",this.handleLastMessages,this);this.model.on("messages:new",this.handleMessages,this);this.model.on("operator:typing",this.handleOperatorTyping,this);this.settings.on("change",this.renderSettings,this);this.renderSettings();this.model.checkOperators()},setState:function(h){if(this.state==h){return}this.state=h;this.$el.removeClass("login-form chat-box contact-form loading-screen info-screen");switch(h){case"loading":this.$el.addClass("loading-screen");this.$title.html(b.ui.loadingLabel);break;case"chat":this.$el.addClass("chat-box");this.$title.html(b.ui.chatHeader);for(var f=0;f<this.model.lastMessages.length;f++){var e=this.model.lastMessages[f];var g=new d.MessageModel({authorType:e.authorType,author:e.authorType==="guest"?e.author:this.model.getOperatorName(e.from_id),body:e.body,time:new Date(e.datetime)});this.chatBox.addMessage(g,true)}this.prevState=h;break;case"login":this.$el.addClass("login-form");this.$title.html(b.ui.chatHeader);this.prevState=h;break;case"contact":this.$el.addClass("contact-form");this.$title.html(b.ui.contactHeader);this.prevState=h;break;case"info":this.$el.addClass("info-screen");break}},toggle:function(){var e;if(this.visible){e=-(this.$el.height()-this.$header.height());this.$el.removeClass("customer-chat-visible");this.$settings.hide();this.$emoticons.hide()}else{e=-1;this.$el.addClass("customer-chat-visible");this.stopTitleBlink()}this.visible=!this.visible;this.$frame.animate({bottom:e+"px"},"fast")},autoLogin:function(){this.showLoading();this.model.autoLogin()},login:function(){var e={name:this.$loginName.val(),mail:this.$loginMail.val(),image:this.selectAvatar.selected};if(!this.loginForm.isValid()){return}this.showLoading();this.model.login(e)},loginOnEnter:function(f){if(f.which===13){this.login()}},toggleSettings:function(){if(!this.visible){return}if(this.$settings.is(":visible")){this.$settings.fadeOut("fast")}else{this.$settings.fadeIn("fast")}},toggleEmoticons:function(){if(this.emotsVisible){this.hideEmoticons()}else{this.showEmoticons()}},showEmoticons:function(){this.emotsVisible=true;this.$emoticons.fadeIn("fast");var e=this;setTimeout(function(){c("html, body").bind("click.hideemots",c.proxy(e.hideEmoticons,e))},10)},hideEmoticons:function(){this.emotsVisible=false;c("html, body").unbind(".hideemots");this.$emoticons.fadeOut("fast")},toggleSetting:function(e){var g=c(e.currentTarget);var f=g.attr("id").split("customer-chat-setting-toggle-")[1];this.settings.set(f,!this.settings.get(f))},renderSettings:function(){this.settings.get("sound")?this.$toggleSound.removeClass("customer-chat-disabled"):this.$toggleSound.addClass("customer-chat-disabled");this.settings.get("scroll")?this.$toggleScroll.removeClass("customer-chat-disabled"):this.$toggleScroll.addClass("customer-chat-disabled");this.settings.get("emots")?this.$toggleEmots.removeClass("customer-chat-disabled"):this.$toggleEmots.addClass("customer-chat-disabled");this.settings.get("show")?this.$toggleShow.removeClass("customer-chat-disabled"):this.$toggleShow.addClass("customer-chat-disabled")},addEmoticon:function(f){var e=c(f.currentTarget);this.$input.val(this.$input.val()+" "+e.data("emot")+" ");this.$input.focus();this.$emoticons.fadeOut("fast")},handleMessages:function(h){for(var f=0;f<h.length;f++){var e=h[f];e.authorType="operator";e.author=this.model.getOperatorName(e.from_id);var g=new d.MessageModel(e);g.fromUser=e.from_user_info;this.chatBox.addMessage(g)}if(this.settings.get("sound")){d.service.soundPlayer.play("message")}if(!this.visible){if(this.settings.get("show")){this.toggle()}else{this.startTitleBlink()}}setTimeout(c.proxy(this.stopTypingInfoBlink,this),1)},handleLastMessages:function(g){for(var e=0;e<g.length;e++){var f=new d.MessageModel(g[e]);this.chatBox.addMessage(f,true)}},sendMessage:function(f){this.handleTyping();if(f.keyCode!==13||f.shiftKey){return}var e=this.$input.val();if(e.length==0){return}var g=new d.MessageModel({author:this.model.get("name"),authorType:"guest",body:e,time:new Date(),from_user_info:{image:this.model.get("image")}});this.model.sendMessage(g);this.chatBox.addMessage(g,true);this.$input.val("")},handleTyping:function(){this.model.updateTypingStatus()},handleOperatorTyping:function(){this.startTypingInfoBlink();if(this.stopTypingBlinkTimer){clearTimeout(this.stopTypingBlinkTimer)}this.stopTypingBlinkTimer=setTimeout(c.proxy(this.stopTypingInfoBlink,this),a.TYPING_STATUS_TIME)},sendContactMessage:function(){var e={name:this.$contactName.val(),mail:this.$contactMail.val(),question:this.$contactMessage.val()};if(!this.contactForm.isValid()){return}var f=this;c.post(b.contactPath,e,function(g){if(g.success){f.contactForm.reset();f.showInfo(b.ui.contactSuccessMessage,b.ui.contactSuccessHeader)}else{f.showInfo(b.ui.contactErrorMessage,b.ui.contactErrorHeader)}});this.showLoading()},startTitleBlink:function(){this.titleBlinking=true;this.blinkTitle()},blinkTitle:function(){if(!this.titleBlinking){return}var e=this;this.$title.fadeOut("slow",function(){e.$title.fadeIn("slow",function(){e.blinkTitle()})})},stopTitleBlink:function(){this.titleBlinking=false},startTypingInfoBlink:function(){if(!this.typingInfoBlinking){this.typingInfoBlinking=true;this.blinkTypingInfo()}},blinkTypingInfo:function(){if(!this.typingInfoBlinking){return}var e=this;this.$typingInfo.fadeIn("slow",function(){e.$typingInfo.fadeOut("slow",function(){e.blinkTypingInfo()})})},stopTypingInfoBlink:function(){this.typingInfoBlinking=false},showLogin:function(){this.setState("login");this.model.once("login:success",this.showWelcomeMessage,this)},showLoginError:function(){this.showInfo(b.ui.loginError)},showWelcomeMessage:function(){var e=new d.MessageModel({authorType:"operator",author:b.ui.initMessageAuthor,body:b.ui.initMessageBody,time:new Date()});this.chatBox.addMessage(e)},showChat:function(){this.setState("chat")},showContact:function(){this.setState("contact")},showLoading:function(){this.setState("loading")},showInfo:function(f,e){this.$info.html(f);this.$title.html(e);this.setState("info")},showPrevState:function(){this.setState(this.prevState)}},{TYPING_STATUS_TIME:2000})})(window.Application,jQuery,window.chatConfig);
// Select avatar inline view
;(function(c,a,b){c.SelectAvatarInlineView=Backbone.View.extend({events:{"mousedown .prev-avatar":"prev","mousedown .next-avatar":"next"},selectedIndex:0,initialize:function(){this.render();this.updateAvatar()},render:function(){this.$el.html(c.template.selectAvatarContent);this.$selected=this.$(".selected-avatar");return this},prev:function(){this.selectedIndex--;if(this.selectedIndex<0){this.selectedIndex=this.model.length-1}this.updateAvatar()},next:function(){this.selectedIndex++;if(this.selectedIndex>=this.model.length){this.selectedIndex=0}this.updateAvatar()},updateAvatar:function(){this.selected=this.model[this.selectedIndex];this.$selected.css("background-image",'url("'+this.selected+'")')}})})(window.Application,chatConfig,jQuery);
// widget.js
;jQuery(function(a){a.get(window.chatConfig.templatesPath,function(c){var b=a(c);var d=window.Application;d.service.soundPlayer=new d.SoundPlayer();d.template.message=b.find("#message").html();d.model.settings=new d.GuestSettingsModel();d.model.chat=new d.GuestChatModel();d.view.widget=new d.WidgetView({el:"#customer-chat-widget",model:d.model.chat})})});
